﻿namespace Hims.Api.Controllers
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Microsoft.AspNetCore.Authorization;
    using Microsoft.AspNetCore.Mvc;
    using Hims.Api.Utilities;
    using Hims.Domain.Services;
    using Hims.Shared.DataFilters;
    using Hims.Shared.EntityModels;
    using Hims.Shared.UserModels.Filters;
    using Hims.Shared.UserModels.Pharmacy;

    // ReSharper disable StyleCop.SA1126

    /// <summary>
    /// The patients controller.
    /// </summary>
    [Route("api/pharmacy-tracking")]
    [Consumes("application/json")]
    [Produces("application/json")]
    public class PharmacyTrackingController : BaseController
    {
        /// <summary>
        /// the pharmacy Tracking service
        /// </summary>
        private readonly IPharmacyTrackingService pharmacyTrackingServices;

        /// <inheritdoc />
        public PharmacyTrackingController(IPharmacyTrackingService pharmacyTrackingServices) => this.pharmacyTrackingServices = pharmacyTrackingServices;

        /// <summary>
        /// The fetch pharmacy products.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        [HttpPost]
        [Route("fetch-purchased-products")]
        public async Task<ActionResult> FetchPharmacyProducts()
        {
            //model = (PharmacyPurchaseReportBill)EmptyFilter.Handler(model);
            var response = await this.pharmacyTrackingServices.FetchPharmacyProducts();
            return this.Success(response);
        }

        /// <summary>
        /// The fetch pharmacy products purchase.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        [HttpPost]
       // [Authorize]
        [Route("fetch-purchase-details")]
        //[ProducesResponseType(typeof(IEnumerable<PharmacyPurchaseReportBill>), 200)]
        //[ProducesResponseType(500)]

        public async Task<ActionResult> FetchProductPurchaseDetail([FromBody]  PharmacyPurchaseReportBill model)
        {
           model = (PharmacyPurchaseReportBill)EmptyFilter.Handler(model);
            var response = await pharmacyTrackingServices.FetchPurchaseAsync(model);

           if (response == null)
            {
                return ServerError();
            }
            return Success(response);
        }

        /// <summary>
        /// The fetch pharmacy products Main Stock (Transaction Detail) to Retail Store.
        /// </summary>
        /// <param name="model">
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        [HttpPost]
        // [Authorize]
        [Route("fetch-stock-to-retail")]
        //[ProducesResponseType(typeof(IEnumerable<PharmacyPurchaseReportBill>), 200)]
        //[ProducesResponseType(500)]

        public async Task<ActionResult> FetchStock([FromBody] PharmacyPurchaseReportBill model)
        {
            model = (PharmacyPurchaseReportBill)EmptyFilter.Handler(model);
            var response = await pharmacyTrackingServices.FetchStocksAsync(model);
            return response == null ? this.ServerError() : this.Success(response);
        }

        /// <summary>
        /// The fetch pharmacy Retail Store - Direct Sale Detail.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        [HttpPost]
        // [Authorize]
        [Route("fetch-retailstore-sale")]
        //[ProducesResponseType(typeof(IEnumerable<PharmacyPurchaseReportBill>), 200)]
        //[ProducesResponseType(500)]

        public async Task<ActionResult> FetchRetailStoreSale([FromBody] PharmacyPurchaseReportBill model)
        {
            model = (PharmacyPurchaseReportBill)EmptyFilter.Handler(model);
            var response = await pharmacyTrackingServices.FetchRetailStoreSaleAsync(model);
            return response == null ? this.ServerError() : this.Success(response);
        }

        /// <summary>
        /// The fetch pharmacy Retail Store Issue Details to Patient
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        [HttpPost]
        // [Authorize]
        [Route("fetch-retailstore-issue-to-ip")]
        //[ProducesResponseType(typeof(IEnumerable<PharmacyPurchaseReportBill>), 200)]
        //[ProducesResponseType(500)]

        public async Task<ActionResult> FetchRetailStoreIssuedSale([FromBody] PharmacyPurchaseReportBill model)
        {
            model = (PharmacyPurchaseReportBill)EmptyFilter.Handler(model);
            var response = await pharmacyTrackingServices.FetchRetailStoreIssuedSaleAsync(model);
            return response == null ? this.ServerError() : this.Success(response);
        }

        /// <summary>
        /// The fetch pharmacy Retail Store Issue Details to Patient
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        [HttpPost]
        // [Authorize]
        [Route("fetch-Purchased-return")]
        //[ProducesResponseType(typeof(IEnumerable<PharmacyPurchaseReportBill>), 200)]
        //[ProducesResponseType(500)]

        public async Task<ActionResult> FetchPurchasedReturn([FromBody] PharmacyPurchaseReportBill model)
        {
            model = (PharmacyPurchaseReportBill)EmptyFilter.Handler(model);
            var response = await pharmacyTrackingServices.FetchPurchasedReturnAsync(model);
            return response == null ? this.ServerError() : this.Success(response);
        }

        /// <summary>
        /// The fetch pharmacy Retail Store Issue Details to Patient
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        [HttpPost]
        // [Authorize]
        [Route("fetch-sale-return")]
        //[ProducesResponseType(typeof(IEnumerable<PharmacyPurchaseReportBill>), 200)]
        //[ProducesResponseType(500)]

        public async Task<ActionResult> FetchSoldReturn([FromBody] PharmacyPurchaseReportBill model)
        {
            model = (PharmacyPurchaseReportBill)EmptyFilter.Handler(model);
            var response = await pharmacyTrackingServices.FetchSoldReturnAsync(model);
            return response == null ? this.ServerError() : this.Success(response);
        }

        /// <summary>
        /// The fetch pharmacy Retail Store Issue Details to Patient
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        [HttpPost]
        // [Authorize]
        [Route("fetch-retail-moved")]
        //[ProducesResponseType(typeof(IEnumerable<PharmacyPurchaseReportBill>), 200)]
        //[ProducesResponseType(500)]

        public async Task<ActionResult> FetchRetailToMainMoved([FromBody] PharmacyPurchaseReportBill model)
        {
            model = (PharmacyPurchaseReportBill)EmptyFilter.Handler(model);
            var response = await pharmacyTrackingServices.FetchRetailToMainMovedAsync(model);
            return response == null ? this.ServerError() : this.Success(response);
        }

        /// <summary>
        /// The fetch pharmacy Retail Store Status Detail
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        [HttpPost]
        // [Authorize]
        [Route("fetch-retail-record")]
        //[ProducesResponseType(typeof(IEnumerable<PharmacyPurchaseReportBill>), 200)]
        //[ProducesResponseType(500)]

        public async Task<ActionResult> FetchRetailRecord([FromBody] PharmacyPurchaseReportBill model)
        {
            model = (PharmacyPurchaseReportBill)EmptyFilter.Handler(model);
            var response = await pharmacyTrackingServices.FetchRetailRecordAsync(model);
            return response == null ? this.ServerError() : this.Success(response);
        }

        /// <summary>
        /// The fetch WareHouse Store Status Detail
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        [HttpPost]
        // [Authorize]
        [Route("fetch-wareHouse-record")]
        //[ProducesResponseType(typeof(IEnumerable<PharmacyPurchaseReportBill>), 200)]
        //[ProducesResponseType(500)]

        public async Task<ActionResult> FetchWareHouseRecord([FromBody] PharmacyPurchaseReportBill model)
        {
            model = (PharmacyPurchaseReportBill)EmptyFilter.Handler(model);
            var response = await pharmacyTrackingServices.FetchWareHouseRecordAsync(model);
            return response == null ? this.ServerError() : this.Success(response);
        }
    }
}
